function [sus] = get_sus_matrix(freq, Gamma, peak_pos, g0_mech_cav, ...
    par)

    function y = chi_inv(n)
        y = Gamma(n)/2 - 1i*(omega - peak_omega(n));
    end

    function y = chi_opt(w)
        y = 1/(par.opt.K/2 - 1i*(w + par.opt.det));
    end

    function y = kroneckerDelta(m,n)
        y = m==n;
    end 

Gamma = Gamma*2*pi;
omega = freq;
peak_omega = peak_pos*2*pi;

dim = size(peak_pos, 2);
M = zeros(dim, dim);

eta = chi_opt(omega) - conj(chi_opt(-omega));

for m=1:dim
    for n=1:dim
        if rem(m,2)==1 && rem(n,2)==1
            M(m,n) = (chi_inv(n)*kroneckerDelta(m,n) + ...
                1i*par.opt.nc*eta*g0_mech_cav(n)*g0_mech_cav(m))...
                /sqrt(Gamma(n));
        elseif rem(m,2)==0 && rem(n,2)==0
            M(m,n) = (conj(chi_inv(n))*kroneckerDelta(m,n) + ...
                1i*par.opt.nc*eta*g0_mech_cav(n)*g0_mech_cav(m))...
                /sqrt(Gamma(n));
        else
            M(m,n) = 1i*par.opt.nc*eta*g0_mech_cav(n)*g0_mech_cav(m)...
                /sqrt(Gamma(n));
        end
    end
end

sus = inv(M);

end